<!DOCTYPE html>
<html lang="en">
    
<meta http-equiv="content-type" content="text/html;charset=utf-8" /> 
    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <meta http-equiv="X-UA-Compatible" content="ie=edge" />
        <link rel="shortcut icon" href="favicon.ico" />
        <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" />
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.2/css/all.min.css" />
        <link rel="stylesheet" href="css/style.css" />
        <meta name="description" content="Coreum is a Smart-Contract proof-of-stake blockchain built as a core infrastructure for the future of decentralized applications and Defi." />
        <meta name="keywords" content="blockchain,smart contract,dapps,defi,hackathon,grants" />
        <title>Coreum | The Layer-1 Smart Blockchain for All: dApps and DeFi</title>
        <meta property="og:image" content="assets/seo-images/home.html" />
    </head>
    <body>
       
        <nav class="desktop-navigation dsk-only">
            <div class="ellipse1" id="header-ellipse"></div>
            <a href="#"><img class="coreum-logo" src="assets/images/coreum-logo.png" alt="Coreum Logo" /></a>
            <div class="links-header">
                <div class="dropdown-container">
                    Developers
                    <div class="dropdown-menu">
                        <a href="#">Developers Hub</a><a href="#">Validators</a><a href="#">Grants</a><a href="#">Exchange Integration</a>
                        <a href="https://join.coreum.com/" target="_blank" rel="noreferrer">Join The Team<img src="assets/images/icons/external.png" /></a>
                    </div>
                    <img src="assets/images/icons/caret.png" />
                </div>
                <div class="dropdown-container">
                    Ecosystem
                    <div class="dropdown-menu">
                        <a href="#">Roadmap</a><a href="#">Architecture</a><a href="#">Projects</a><a href="#">EGB Networks</a><a href="#">Smart Tokens</a>
                        <a href="#">CORE Team</a><a href="#" download="coreum_technical_paper">Whitepaper<img src="assets/images/icons/external.png" /></a>
                    </div>
                    <img src="assets/images/icons/caret.png" />
                </div>
                <div class="dropdown-container">
                    Community
                    <div class="dropdown-menu"><a href="#">Community</a><a href="#">Press &amp; Media</a><a href="#">Core Nova</a></div>
                    <img src="assets/images/icons/caret.png" />
                </div>
                <a href="#" target="_blank" rel="noopener noreferrer">Explorer<img src="assets/images/icons/external.png" /></a>
            </div>
        </nav>
        <nav class="mobile-navigation mob-only">
            <i class="fas fa-bars hoverable action-menu"></i><a href="#"><img class="coreum-logo" src="assets/images/coreum-logo.png" alt="Coreum Logo" /></a>
            <div class="spacer"></div>
            <div class="mobile-menu">
                <div class="main-links">
                    <div class="link" id="developers-menu-target" data-value="developers">Developers<img src="assets/images/icons/caret.png" id="developers-caret" data-value="developers" /></div>
                    <div class="submenu-links" id="developers-menu">
                        <a href="#">Developers Hub</a><a href="#">Validators</a><a href="#">Grants</a><a href="#">Exchange Integration</a>
                        <a href="https://join.coreum.com/" target="_blank" rel="noreferrer">Join The Team<img src="assets/images/icons/external.png" /></a>
                    </div>
                    <div class="link" id="ecosystem-menu-target" data-value="ecosystem">Ecosystem<img src="assets/images/icons/caret.png" id="ecosystem-caret" data-value="ecosystem" /></div>
                    <div class="submenu-links" id="ecosystem-menu">
                        <a href="#">Roadmap</a><a href="#">Architecture</a><a href="#">Projects</a><a href="#">EGB Networks</a><a href="#">Smart Tokens</a>
                        <a href="#">CORE Team</a><a href="#">Whitepaper</a>
                    </div>
                    <div class="link" id="community-menu-target" data-value="community">Community<img src="assets/images/icons/caret.png" id="community-caret" data-value="community" /></div>
                    <div class="submenu-links" id="community-menu"><a href="#">Community</a><a href="#">Press &amp; Media</a><a href="#">Core Nova</a></div>
                    <a href="https://explorer.coreum.com/" target="_blank" rel="noopener noreferrer">Explorer<img src="assets/images/icons/external.png" /></a>
                </div>
            </div>
        </nav>
        <div class="page-home page">
            <div class="home-hero">
                <!-- <lottie-player src="assets/animations/lottie-landing.json" background="index.html" speed="1" style="width: 100%; height: 100%;" loop="loop" autoplay="autoplay"></lottie-player> -->
                <div class="hero-text">
                    <h1 class="hero-title">Enterprise Grade Blockchain</h1>
                    <h2 class="hero-subtitle">Modular, Fast, Secure and Interoperable</h2>
                </div>
                <!-- <lottie-player class="arrow" src="assets/animations/lottie-green-arrow.json" background="index.html" speed="1" style="width: 128px; height: 128px;" loop="loop" autoplay="autoplay"></lottie-player> -->
            </div>

            <div class="row">

                <div class="col-md-3 mt-4">
                     <div class="links"><a class="coreum-btn" href="web">Mainnet</a></div>
                </div>

                <div class="col-md-3 mt-4">
                     <div class="links"><a class="coreum-btn" href="web">Delegate </a></div>
                </div>

                <div class="col-md-3 mt-4">
                     <div class="links"><a class="coreum-btn" href="web">Bridge </a></div>
                </div>

                <div class="col-md-3 mt-4">
                     <div class="links"><a class="coreum-btn" href="web">Claim Airdrop</a></div>
                </div>
                

            </div>
           




            <div class="features">
                <a class="seq_item" href="#ultra-fast" id="highlight-headers-1" data-value="1" onmouseover="handleHover(this)" onmouseleave="handleOut()">Ultra Fast</a>
                <a class="seq_item" href="#scalable" id="highlight-headers-2" data-value="2" onmouseover="handleHover(this)" onmouseleave="handleOut()">Scalable</a>
                <a class="seq_item" href="#interoperable" id="highlight-headers-3" data-value="3" onmouseover="handleHover(this)" onmouseleave="handleOut()">Interoperable</a>
                <a class="seq_item" href="#sustainable" id="highlight-headers-4" data-value="4" onmouseover="handleHover(this)" onmouseleave="handleOut()">Sustainable</a>
                <div class="ellipse2"></div>
            </div>
            <div class="home-intro">
                <p>
                    Coreum is the first <b>EGB</b>. A new generation of blockchains that is geared towards enterprise needs in compliance with
                    <a href="https://www.iso20022.org/" target="_blank" rel="noopener noreferrer"><y>ISO20022</y></a>. Launch DeFi applications and protocols for businesses of any size.
                </p>
                <a class="coreum-btn transparent action" href="#">What's EGB?</a>
            </div>
            <div class="meet-coreum">
                <div class="meet-text">MEET COREUM</div>
                <iframe
                    src="https://www.youtube.com/embed/36ASVQWz4yg"
                    title="YouTube video player"
                    frameborder="0"
                    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                    allowfullscreen="allowfullscreen"
                ></iframe>
            </div>
            <div class="smart-tokens-container">
                <div class="st-box">
                    <div class="st-graphic"></div>
                    <div class="st-info">
                        <div class="st-title">Smart Tokens</div>
                        <div class="st-body">Token issuance just got a lot more <b>powerful</b>. Tackle the next generation of Blockchain-based assets, supercharged with <b>Smart Contracts</b>.</div>
                        <a class="st-action" href="#">Learn More</a>
                    </div>
                </div>
            </div>
            <div class="validator-types">
                <div class="title">The Coreum Ecosystem is Growing</div>
                <div class="marquee carousel-top">
                    <div class="marquee-container">
                        <div class="validator-cards" id="types-of-validators">
                            <a class="validator" href="https://www.zeeve.io/" target="_blank" rel="noopener noreferrer">
                                <img class="validatorImg projectImg" src="assets/images/home/partnerships/zeeve.png" /><img class="validatorImg-hover" src="assets/images/home/partnerships/zeeve.png" />
                            </a>
                            <a class="validator" href="https://www.telios.io/#/" target="_blank" rel="noopener noreferrer">
                                <img class="validatorImg projectImg" src="assets/images/home/partnerships/telios.png" /><img class="validatorImg-hover" src="assets/images/home/partnerships/telios.png" />
                            </a>
                            <a class="validator" href="https://dcentwallet.com/products/BiometricWallet" target="_blank" rel="noopener noreferrer">
                                <img class="validatorImg projectImg" src="assets/images/home/partnerships/dcent.png" /><img class="validatorImg-hover" src="assets/images/home/partnerships/dcent.png" />
                            </a>
                            <a class="validator" href="https://www.stably.io/" target="_blank" rel="noopener noreferrer">
                                <img class="validatorImg projectImg" src="assets/images/home/partnerships/stably.png" /><img class="validatorImg-hover" src="assets/images/home/partnerships/stably.png" />
                            </a>
                            <a class="validator" href="https://www.co2mmon.eu/" target="_blank" rel="noopener noreferrer">
                                <img class="validatorImg projectImg" src="assets/images/home/partnerships/common.png" /><img class="validatorImg-hover" src="assets/images/home/partnerships/common.png" />
                            </a>
                            <a class="validator" href="https://amber.top/en/" target="_blank" rel="noopener noreferrer">
                                <img class="validatorImg projectImg" src="assets/images/home/partnerships/amber.png" /><img class="validatorImg-hover" src="assets/images/home/partnerships/amber.png" />
                            </a>
                            <a class="validator" href="https://www.emergeinteractive.com/" target="_blank" rel="noopener noreferrer">
                                <img class="validatorImg" src="assets/images/validators/icons/emerge.png" /><img class="validatorImg-hover" src="assets/images/validators/icons/emerge-hover.png" />
                            </a>
                            <a class="validator" href="https://www.stakelab.fr/" target="_blank" rel="noopener noreferrer">
                                <img class="validatorImg" src="assets/images/validators/icons/stakelab.png" /><img class="validatorImg-hover" src="assets/images/validators/icons/stakelab-hover.png" />
                            </a>
                            <a class="validator" href="https://citadel.one/" target="_blank" rel="noopener noreferrer">
                                <img class="validatorImg" src="assets/images/validators/icons/citadel.png" /><img class="validatorImg-hover" src="assets/images/validators/icons/citadel-hover.png" />
                            </a>
                            <a class="validator" href="https://stakewolle.com/" target="_blank" rel="noopener noreferrer">
                                <img class="validatorImg" src="assets/images/validators/icons/shark.png" /><img class="validatorImg-hover" src="assets/images/validators/icons/shark-hover.png" />
                            </a>
                            <a class="validator" href="https://www.bitrue.com/home/" target="_blank" rel="noopener noreferrer">
                                <img class="validatorImg" src="assets/images/validators/icons/bitrue.png" /><img class="validatorImg-hover" src="assets/images/validators/icons/bitrue-hover.png" />
                            </a>
                            <a class="validator" href="https://www.hashquark.io/" target="_blank" rel="noopener noreferrer">
                                <img class="validatorImg" src="assets/images/validators/icons/hashquark.png" /><img class="validatorImg-hover" src="assets/images/validators/icons/hashquark-hover.png" />
                            </a>
                        </div>
                    </div>
                </div>
                <div class="marquee carousel-bottom">
                    <div class="marquee-container">
                        <div class="validator-cards" id="types-of-validators">
                            <a class="validator" href="https://www.hashquark.io/#/" target="_blank" rel="noopener noreferrer">
                                <img class="validatorImg" src="assets/images/validators/icons/harvest.png" /><img class="validatorImg-hover" src="assets/images/validators/icons/harvest-hover.png" />
                            </a>
                            <a class="validator" href="https://www.huobi.com/en-us/" target="_blank" rel="noopener noreferrer">
                                <img class="validatorImg" src="assets/images/validators/icons/huobi.png" /><img class="validatorImg-hover" src="assets/images/validators/icons/huobi-hover.png" />
                            </a>
                            <a class="validator" href="https://virtualhive.io/" target="_blank" rel="noopener noreferrer">
                                <img class="validatorImg" src="assets/images/validators/icons/ch.png" /><img class="validatorImg-hover" src="assets/images/validators/icons/ch-hover.png" />
                            </a>
                            <a class="validator" href="https://www.cosmostation.io/" target="_blank" rel="noopener noreferrer">
                                <img class="validatorImg" src="assets/images/validators/icons/cosmostation.png" /><img class="validatorImg-hover" src="assets/images/validators/icons/cosmostation-hover.png" />
                            </a>
                            <a class="validator" href="https://www.informal.systems/" target="_blank" rel="noopener noreferrer">
                                <img class="validatorImg" src="assets/images/validators/icons/informal.png" /><img class="validatorImg-hover" src="assets/images/validators/icons/informal-hover.png" />
                            </a>
                            <a class="validator" href="https://www.forbole.com/" target="_blank" rel="noopener noreferrer">
                                <img class="validatorImg" src="assets/images/validators/icons/forbole.png" /><img class="validatorImg-hover" src="assets/images/validators/icons/forbole-hover.png" />
                            </a>
                            <a class="validator" href="https://www.stakecito.com/" target="_blank" rel="noopener noreferrer">
                                <img class="validatorImg" src="assets/images/validators/icons/stakecito.png" /><img class="validatorImg-hover" src="assets/images/validators/icons/stakecito-hover.png" />
                            </a>
                        </div>
                    </div>
                </div>
                <div class="validator-buttons"><a class="coreum-btn" href="web">Validators</a><a class="coreum-btn transparent" href="web">Projects</a></div>
            </div>
            <div class="ultra-fast" id="ultra-fast">
                <div class="left">
                    <div class="title">Build on the Fastest Layer-1</div>
                    <div class="subtitle">With the ability to process <b>7000 transactions per second</b> with a federated group of <b>32 rotating validators</b>, Coreum is the fastest blockchain in the world.</div>
                </div>
                <div class="right">
                    <div class="item">
                        <div class="subtitle left">up to</div>
                        <div class="title" id="count">7000</div>
                        <div class="subtitle">Transactions Per Second</div>
                    </div>
                    <div class="item">
                        <div class="title">32</div>
                        <div class="subtitle">Validators</div>
                    </div>
                </div>
            </div>
            <div class="scalable" id="scalable">
                <!-- <lottie-player src="assets/animations/lottie-heartbeat.json" background="index.html" speed="1" style="width: 100%; height: 100%;" loop="loop" autoplay="autoplay"></lottie-player> -->
                <div class="container">
                    <div class="info">
                        <div class="pre-title">Open-Source Developers Incentivization</div>
                        <div class="title">Scale With No Limits</div>
                        <div class="details">
                            Using the well-established <b>Tendermint Consensus Engine</b> and <b>Cosmos SDK</b>, Coreum brings a low-latency proof-of-stake blockchain. <br />
                            <b> More powerful, more efficient than proof-of-work. </b>
                        </div>
                    </div>
                </div>
            </div>
            <div class="interoperable">
                <div class="left" id="interoperable">
                    <div class="title">Smart Contracts</div>
                    <div class="details">
                        Applications can be written in many languages and compiled into the modern turing-complete <b>Web Assembly (WASM)</b> before processing.<br />
                        <br />
                        <b>CosmWasm:</b> A multi-chain solution to build and run contracts on the whole cosmos ecosystem.
                    </div>
                </div>
                <div class="right">
                    <div class="pre-title">Web Assembly</div>
                    <div class="title">WASM</div>
                    <div class="subtitle">Smart Contract</div>
                </div>
                <img src="assets/images/home/graphic2.png" />
                <div class="container">
                    <div class="info">
                        <div class="title">A Multi-Chain Future</div>
                        <div class="details">With hundreds of Blockchains currently being used, Coreum deploys a <b>bridge functionality</b> to interoperate with various chains through <b>collateralized wrapping</b>.</div>
                    </div>
                </div>
            </div>
            <div class="devs-incentive">
                <div class="title">Open-Source Developers Incentivization</div>
                <div class="body">Built on the <b>Tendermint Core BFT</b> utilizing many of the Cosmos-like modules, Coreum is destined to scale.</div>
                <div class="buttons"><a class="primary" href="#">apply for a grant</a><a class="secondary" href="#">join the team</a></div>
            </div>
            <div class="sustainable" id="sustainable">
                <div class="left">
                    <div class="pre-title">Community-Powered</div>
                    <div class="title">BPoS Consensus Mechanism</div>
                    <div class="details">
                        Coreum is the home of all the open-source developers, token holders, validators, and members supporting the protocol. With <b>on-chain governance</b>, the Coreum community can decide on protocol changes and define
                        the blockchain's future.
                    </div>
                </div>
                <div class="right">
                    <div class="item">
                        <div class="title">99%</div>
                        <div class="subtitle">Lower Carbon Footprint</div>
                    </div>
                </div>
                <div class="ellipse3"></div>
            </div>
            <div class="connect-mainnet home-connect">
                <div class="connect-wallets">
                    <a class="wallet-button" href="https://www.leapwallet.io/" target="_blank" rel="noopener noreferrer">
                        <img class="wallet" src="assets/images/cex/wallets/leap.png" /><img class="wallet-hover" src="assets/images/cex/wallets/leap-hover.png" />
                    </a>
                    <a class="wallet-button" href="https://airgap.it/" target="_blank" rel="noopener noreferrer">
                        <img class="wallet" src="assets/images/cex/wallets/airgap.png" /><img class="wallet-hover" src="assets/images/cex/wallets/airgap-hover.png" />
                    </a>
                    <a class="wallet-button" href="https://www.dcentwallet.com/" target="_blank" rel="noopener noreferrer">
                        <img class="wallet" src="assets/images/cex/wallets/dcent.png" /><img class="wallet-hover" src="assets/images/cex/wallets/dcent-hover.png" />
                    </a>
                    <a class="wallet-button" href="https://citadel.one/" target="_blank" rel="noopener noreferrer">
                        <img class="wallet" src="assets/images/cex/wallets/citadel.png" /><img class="wallet-hover" src="assets/images/cex/wallets/citadel-hover.png" />
                    </a>
                    <a class="wallet-button" href="https://www.cosmostation.io/" target="_blank" rel="noopener noreferrer">
                        <img class="wallet" src="assets/images/cex/wallets/cosmostation.png" /><img class="wallet-hover" src="assets/images/cex/wallets/cosmostation-hover.png" />
                    </a>
                </div>
                <div class="connect-info">
                    <div class="connect-title">Connect to the Coreum Mainnet</div>
                    <div class="connect-description">Amidst Mainnet launch, these wallets will be supporting Coreum providing access to different decentralized applications and DeFi capabilities.</div>
                </div>
            </div>
            <div class="join-community section-basic">
                <div class="left">
                    <div class="title">Join the Coreum Dev Community</div>
                    <div class="details">Follow the latest updates, participate in Hackathon events, and be loud across the Coreum community channels.</div>
                </div>
                <div class="right">
                    <a class="card" href="https://twitter.com/CoreumOfficial" target="_blank" rel="noopener noreferrer"><img src="assets/images/home/social/twitter.svg" /></a>
                    <a class="card" href="https://t.me/CoreumOfficial" target="_blank" rel="noopener noreferrer"><img src="assets/images/home/social/telegram.svg" /></a>
                    <a class="card" href="https://discord.gg/XdVAGKXEhg" target="_blank" rel="noopener noreferrer"><img src="assets/images/home/social/discord.svg" /></a>
                    <a class="card" href="https://www.youtube.com/channel/UCIFix5W3gRgA4mSiXE268IA" target="_blank" rel="noopener noreferrer"><img src="assets/images/home/social/youtube.svg" /></a>
                </div>
            </div>
        </div>
        <footer>
            <div class="footer-body">
                <div class="logo-and-socials">
                    <img class="logo" src="assets/images/coreum-logo.png" />
                    <div class="social-icons">
                        <a href="https://twitter.com/CoreumOfficial" target="_blank" rel="noopener noreferrer"><img class="social-icon" src="assets/images/social/twitter.png" /></a>
                        <a href="https://t.me/CoreumOfficial" target="_blank" rel="noopener noreferrer"><img class="social-icon" src="assets/images/social/telegram.png" /></a>
                        <a href="https://discord.gg/XdVAGKXEhg" target="_blank" rel="noopener noreferrer"><img class="social-icon" src="assets/images/social/discord.png" /></a>
                        <a href="https://www.youtube.com/channel/UCIFix5W3gRgA4mSiXE268IA" target="_blank" rel="noopener noreferrer"><img class="social-icon" src="assets/images/social/youtube.png" /></a>
                    </div>
                </div>
                <div class="newsletter">
                    <div class="body-main formtitle">Subscribe to the Coreum Newsletter:</div>
                    <div class="input-and-btn"><input type="email" placeholder="Enter your email address" id="newsletterEmail" /><button id="newsletterBtn">Submit</button></div>
                </div>
                <div class="sitemap">
                    <div class="column">
                        <p class="subtitle">Community</p>
                        <a href="#">Core Community</a><a href="#">Press &amp; Media</a>
                        <a href="https://open.spotify.com/show/20Qe2THhu2Jmi1foyrPTzK?si=07032b7dfa4f4576" target="_blank" rel="noopener noreferrer">Podcast</a>
                        <a href="https://discord.gg/XdVAGKXEhg" target="_blank" rel="noopener noreferrer">Join Our Discord</a>
                        <a href="https://twitter.com/CoreumOfficial" target="_blank" rel="noopener noreferrer">Join Our Twitter</a>
                    </div>
                    <div class="column">
                        <p class="subtitle">Resources</p>
                        <a href="https://explorer.coreum.com/" target="_blank" rel="noopener noreferrer">Explorer</a><a href="#" download="coreum_technical_paper">Whitepaper</a>
                        <a href="https://sologenic.medium.com/coreum-airdrop-100m-core-for-sologenic-community-and-solo-holders-d7dc73c9271d" target="_blank" rel="noopener noreferrer">Airdrop Distribution</a>
                        <a href="#">Privacy Policy</a><a href="#">Contact</a>
                    </div>
                    <div class="column">
                        <p class="subtitle">Developers Hub</p>
                        <a href="#">Developers Hub</a><a href="#">Validators</a><a href="#">Grants</a><a href="#">footer.cex</a>
                        <a href="https://join.coreum.com/" target="_blank" rel="noopener noreferrer">Join Our Team</a>
                    </div>
                    <div class="column">
                        <p class="subtitle">Ecosystem</p>
                        <a href="#">Roadmap</a><a href="#">Architecture</a><a href="#">Use Cases</a><a href="#">CORE Token</a><a href="#">CORE Team</a>
                    </div>
                </div>
            </div>
            <div class="copyright"><p>Copyright © 2021 - 2023 Coreum Development Foundation Limited. All rights reserved</p></div>
        </footer>
        <script src="https://code.jquery.com/jquery-3.4.1.min.js" integrity="sha256-CSXorXvZcTkaix6Yvo6HppcZGetbYMGWSFlBw8HfCJo=" crossorigin="anonymous"></script>
        <script src="https://cdn.jsdelivr.net/npm/jquery.marquee%401.6.0/jquery.marquee.min.js" type="text/javascript"></script>
        <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>
        <script src="https://unpkg.com/%40lottiefiles/lottie-player%401.7.1/dist/lottie-player.js"></script>
        
        <script async="async" src="https://www.googletagmanager.com/gtag/js?id=G-3K5CT41HGY"></script>
        <script>
            window.dataLayer = window.dataLayer || [];
            function gtag() {
                dataLayer.push(arguments);
            }
            gtag("js", new Date());
            gtag("config", "G-3K5CT41HGY");
        </script>
        <!-- OWN SCRIPTS -->
        <script src="js/easytimer.js"></script>
        <script src="js/menu.js"></script>
        <script src="js/page.js"></script>
        <script src="js/rewards.js"></script>
        <script src="js/marquee.js"></script>
    </body> 


</html>
