$(document).scroll((e) => {
  const header = $(".mobile-navigation");
  if (!$(window).scrollTop()) {
    header.css("background", "unset");
  } else header.css("background", "#0b161e");
});

let show = false;
let submenu = "";

const toggleMenu = (e) => {
  if (show) {
    $(".mobile-navigation").removeClass("show");
  } else {
    $(".mobile-navigation").addClass("show");
  }
  show = !show;
};

const showSubmenu = (e) => {
  if (e === submenu) {
    $(`#${submenu}-menu`).removeClass("show");
    $(`#${submenu}-caret`).removeClass("active");
    submenu = "";
  } else {
    if (submenu) {
      $(`#${submenu}-menu`).removeClass("show");
      $(`#${submenu}-caret`).removeClass("active");
    }
    $(`#${e}-menu`).addClass("show");
    $(`#${e}-caret`).addClass("active");
    submenu = e;
  }
};

[
  "developers-menu-target",
  "developers-menu-caret",
  "ecosystem-menu-target",
  "ecosystem-menu-caret",
  "community-menu-caret",
  "community-menu-target",
].map((target) =>
  $(`#${target}`).click((e) => {
    showSubmenu(e.target.dataset.value);
  })
);

$(".action-menu").click(function (e) {
  toggleMenu(e.target.dataset.value);
});

$(".sidelink").click(() => toggleMenu("hide"));

function checkBanner() {
  if (localStorage.banner) {
    const bannerId = $("#banner").data("value");

    if (bannerId !== JSON.parse(localStorage.banner).id) {
      localStorage.banner = null;
      $("#banner").css("display", "flex");
    } else {
      $("#banner").css("display", "none");
    }
  } else {
    $("#banner").css("display", "flex");
  }
}

$("#banner").click((e) => {
  e.stopPropagation();
  window.open(
    "connect-wallet/dapps.html",
    "_blank",
    "noreferrer noopener"
  );
});

$(".close-banner-btn").click((e) => {
  e.stopPropagation();

  const id = $("#banner").data("value");

  localStorage.banner = JSON.stringify({
    id,
    dismissed: true,
  });
  checkBanner();
});

checkBanner();

// desktop dropdowns

let dropdown = "";

function generateMenuControls(name) {
  $("#" + name + "container").click((e) => {
    if (name === dropdown) {
      $("#" + name + "dropdown").removeClass("show");
      $("#" + name + "container").removeClass("show");
      dropdown = "";
    } else {
      $("#" + name + "dropdown").addClass("show");
      $("#" + name + "container").addClass("show");
      dropdown = name;
    }
  });
}

// Remove Ellipse
function removeHeaderEllipse() {
  if (window && window.location.pathname === "/core-nova") {
    $("#header-ellipse").hide();
  }
}

removeHeaderEllipse();
