function calcHeaderHeight() {
  var h = $(".mobile-navigation").outerHeight();

  $(".banner").css("margin-top", `${h}px`);
  $(".page").css("margin-top", `${h}px`);
}

calcHeaderHeight();

$("#newsletterBtn").click(function (e) {
  e.preventDefault();

  $("#newsletterBtn").text("...");

  var email = $("#newsletterEmail").val().trim();

  $.post("/newsletter-submission", { email: email }, function (res) {
    console.log(res);
    if (res.error) {
      $(".formtitle").textContent =
        "Sorry, something went wrong! Try again later.";
      // $("#responseNewsletterSuccess").fadeIn();
      $("#newsletterEmail").val("");
    } else {
      // $("#responseNewsletterSuccess").textContent = "Thank you!";
      // $("#responseNewsletterSuccess").fadeIn();
      $(".formtitle").text("Thank you!");
      $("#newsletterEmail").val("");
      $("#newsletterBtn").text("Submit");
    }
  }).fail(function (e) {
    console.log(e);
    // $("#responseNewsletterFail").css("display", "block");
  });

  // grecaptcha.ready(function () {
  //   grecaptcha
  //     .execute("6Leg-acbAAAAAIqeZSQ0EdO53tAaUB1laEN18PVr", {
  //       action: "SoloNewsletter",
  //     })
  //     .then(function (token) {
  //       console.log(token);
  //       // pass the token to the backend script for verification
  //     });

  //   // grecaptcha
  //   //   // .execute("6LcwUb0UAAAAAO3ZJG_PXOY1uYhTTmTNffPKQz8z", {
  //   //   .execute("6Leg-acbAAAAAIqeZSQ0EdO53tAaUB1laEN18PVr")
  //   //   .then(function (token) {
  //   //     console.log(token);

  //   //   });
  // });
});

// Scroll Roadmap

$(".scroll-roadmap").click((e) => {
  const width = $(".dates").width();
  const currentPosition = $(".dates").scrollLeft();

  const direction = e.currentTarget.dataset.value;

  const scroll = direction === "left" ? -1 : 1;

  $(".dates").scrollLeft((currentPosition + width) * scroll);
});

let current = 1;
const handler = () => {
  if (current <= 4) {
    $("#highlight-headers-" + (current - 1)).removeClass("active");
    $("#highlight-headers-" + current).addClass("active");
    current++;
  } else {
    $("#highlight-headers-4").removeClass("active");
    $("#highlight-headers-1").addClass("active");
    current = 2;
  }
};

function handleHover(e) {
  clearInterval(window.seq_interval);
  $(".seq_item").removeClass("active");
  current = e.dataset.value;
  handler();
}

function handleOut(e) {
  window.seq_interval = setInterval(handler, 1500);
}

if (window.location.pathname === "/") {
  window.seq_interval = setInterval(handler, 1500);
} else {
  window.seq_interval = clearInterval(handler);
}

var slide = 1;

const slides = [
  "/assets/images/core-nova/1.png",
  "/assets/images/core-nova/2.png",
  "/assets/images/core-nova/3.png",
  "/assets/images/core-nova/4.png",
  "/assets/images/core-nova/5.png",
  "/assets/images/core-nova/6.png",
];

function slideshowChange() {
  slide = slide + 1 === 6 ? 1 : slide + 1;

  $(".slideshow-img").attr("src", slides[slide - 1]);

  $(".dot").removeClass("active");
  $(`.dot-${slide}`).addClass("active");
}

setInterval(slideshowChange, 3000);

const timer = new easytimer.Timer();
const date = +new Date("2023-03-24T19:00:00");
const diff = date - +new Date();

timer.start({
  countdown: true,
  startValues: {
    seconds: diff / 1000,
  },
});

timer.addEventListener("secondsUpdated", function (e) {
  const { days, hours, minutes, seconds } = timer.getTimeValues();

  $("#days").text(days);
  $("#hours").text(hours);
  $("#minutes").text(minutes);
  $("#seconds").text(seconds);

  $(".countdown-container").css("display", "flex");
});
