// init values
const fmt = new Intl.NumberFormat("en-US", {
  notation: "compact",
  maximumFractionDigits: 1,
}).format;

$("#amount-value").text(fmt($("#amount-input").data("value")) + " CORE");
$("#locking-value").text(fmt($("#locking-input").data("value")) + " Days");
$("#rewards").text(
  calculateRewards(
    $("#amount-input").data("value"),
    $("#locking-input").data("value")
  ) + " CORE"
);

function generateDragging(name) {
  $(name).mousemove((e) => calculateLog(e.target.value, name));
}

function generateTouch(name) {
  $(name).on("touchmove", (e) => calculateLog(e.target.value, name));
}

function calculateLog(position, name) {
  const isLog = $(name).data("log");

  const min = $(name).data("min");
  const max = $(name).data("max");
  let value = 0;

  if (isLog === 1) {
    const minp = $(name).attr("min");
    const maxp = $(name).attr("max");

    const minv = Math.log(min);
    const maxv = Math.log(max);

    const scale = (maxv - minv) / (maxp - minp);

    value = Math.exp((position - minp) * scale + minv).toFixed();
  } else {
    value = ((position * max) / 100).toFixed();
  }

  $(name).data("value", value);
  $(name).css(
    "background",
    "linear-gradient(to right, #179b69 0%, #25d695 " +
      position +
      "%, #fff " +
      position +
      "%, white 100%)"
  );
  updateLabel(name, value);
  updateRewards(value);
}

function updateLabel(name, value) {
  if (name === "#amount-input") {
    $("#amount-value").text(fmt(value) + " CORE");
  } else {
    $("#locking-value").text(fmt(value) + " Days");
  }
}

function updateRewards(value) {
  return $("#rewards").text(
    calculateRewards(
      $("#amount-input").data("value"),
      $("#locking-input").data("value")
    ) + " CORE"
  );
}

function calculateRewards(amount, time) {
  return fmt((Number(amount) * 0.25 * (Number(time) / 365)).toFixed());
}

["#amount-input", "#locking-input"].map((name) => {
  generateDragging(name);
  generateTouch(name);
});

// function startCalculation() {
//   const amountInput = $("#amount-input");
//   calculateLog(amountInput.val(), amountInput);
// }

// startCalculation();
